/*
This code replicates Figure #: Policy Credibility Distributions
*/
clear
cls
cap cd "Replication_pkg/Figure 8"  

use "Data_fig8.dta"

cd "../Figure 8"

*Plot density by AE EM classification
twoway kdensity iapoc if(time_q == tq(2007q1) & EM == 0), lc(blue) lwidth(thick) ///
	||  (kdensity iapoc if(time_q == tq(2021q1) & EM == 0), lc(blue) lwidth(thick) lp(dash) ) ///
	|| (kdensity iapoc if(time_q == tq(2007q1) & EM==1), lc(red) lwidth(thick)) ///
	||  (kdensity iapoc if(time_q == tq(2021q1) & EM==1), lc(red) lwidth(thick) lp(dash) ), ///
	xtitle("Policy Credibility Index") xlab(, nogrid)  xla(0(.2)1,  labsize(small)) ///
	ytitle("Kernel density") ylab(, nogrid) ///
	legend(label(1 "2007 AE") label(2 "2021 AE") label(3 "2007 EM") label(4 "2021 EM") pos(6) cols(2)) plotregion(style(none)) 
graph export "Figure 8.pdf", replace
